Attribute VB_Name = "InpOut32_Declarations"
'Inp and Out declarations for port I/O using inpout32.dll.

Public Declare Function Inp Lib "inpout32.dll" Alias "Inp32" _
    (ByVal PortAddress As Integer) _
    As Integer
    
Public Declare Sub Out Lib "inpout32.dll" Alias "Out32" _
    (ByVal PortAddress As Integer, _
    ByVal Value As Integer)

Function BitStatus(PortNum%, BitYouWant%) As Integer
    NumOfBits% = 8
    ReDim PortBits(NumOfBits%) As Integer
    For i = 1 To NumOfBits%
        PortBits%(i) = PortNum% Mod 2
        PortNum% = Fix(PortNum% / 2)
    Next i
    BitStatus = PortBits%(BitYouWant%)
End Function

Function user_delay(delay) As Integer
    Dim n As Single
    n = Timer
    While Timer - n < delay: Wend
End Function

Function get_data(input_select, atod_output) As Integer
Dim status_total As Integer
Dim PortAddress As Integer
'Change PortAddress to match the port address to write to:
'(Usual parallel-port addresses are &h378, &h278, &h3BC)
PortAddress = &H378
' put tick in relay on/off box
sensors.relay.Value = 1
atod_output = 0
Out PortAddress, 32 + 8 + input_select 'CS High  SCLK Low -
Out PortAddress, 32 + 0 + input_select  'CS Low   SCLK Low - Start a conversion
' Get bit of data
For n = 11 To 0 Step -1
    ' Clock SCLK - Get bit of data
    Out PortAddress, 32 + 16 + input_select  'CS Low  SCLK High
    Out PortAddress, 32 + 0 + input_select 'CS Low  SCLK Low
    ' Read Status Port
    status_total = Inp(PortAddress + 1)
    status_total = 255 - status_total
    ' Get status of b7 (status port) - 1 or 0.
    status_total = BitStatus(status_total, 8)
    If status_total = 1 Then atod_output = atod_output + (2 ^ n)
Next n
DoEvents
End Function

Function select_input_channel(input_select) As Integer
' First select input channel
Out PortAddress, input_select
' Small delay while Multiplexor switches input channels
Call user_delay(0.2)
End Function

Function toggle_relay() As Integer
    Dim PortAddress As Integer
    PortAddress = &H378
    If sensors.relay.Value = 1 Then Out PortAddress, 32
    If sensors.relay.Value = 0 Then Out PortAddress, 0
End Function


Function relay_off() As Integer
    Dim PortAddress As Integer
    PortAddress = &H378
    Out PortAddress, 0
End Function
